
*This do file shows the estimates for manuscript "Boosting Survey Response Rates by Announcing Undefined Lottery Prizes in Invitation Email Subject Lines: Evidence from a Global Randomized Controlled Trial"
*Note: Some variables generated for the main paper analysis are also used in the analysis presented in the Online-Appendix.

*Changing the directory depends upon the user settings
*cd "ADD DIRECTORY PATH"

*Following estimates are for the main text of the paper, unless otherwise specified

*Table 1: Outcome rates
tab SurveyStat

* Preparing data for regression analysis
*Creating interaction variables to be used in analysis
gen AULPOIC = AULP*OIC
gen AULPTrans = AULP*Trans
gen TransOIC = Trans*OIC
gen AULPTransOIC = AULP*Trans*OIC

*Control variables list
global Controls Mature TM

*Table 2: Testing main hypotheses
*PS: For getting McFadden R2, use "fitstat" after logistic regression (i.e., before margins' command)
logit Contact AULP $Controls, cluster(UniqueMFI) nolog
margins, dydx(AULP) atmeans post

logit Response AULP $Controls, cluster(UniqueMFI) nolog
margins, dydx(AULP) atmeans post

logit Contact AULP OIC AULPOIC $Controls, cluster(UniqueMFI) nolog
margins, dydx(AULP OIC AULPOIC) atmeans post

logit Response AULP OIC AULPOIC $Controls, cluster(UniqueMFI) nolog
margins, dydx(AULP OIC AULPOIC) atmeans post

logit Contact AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC $Controls, cluster(UniqueMFI) nolog
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC) atmeans post

logit Response AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC $Controls, cluster(UniqueMFI) nolog
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC) atmeans post

*Table 3: Sensitivity analyses: Further results on the role of culture
* Creating interaction variables
gen AULPINDIV=AULP*CollIndiv
gen AULPTrust=AULP*DistrustTrust

melogit Contact AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC) atmeans predict(mu fixedonly) post

melogit Response AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC) atmeans predict(mu fixedonly) post

melogit Contact AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC CollIndiv AULPINDIV $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC CollIndiv AULPINDIV) atmeans predict(mu fixedonly) post

melogit Response AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC CollIndiv AULPINDIV $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC CollIndiv AULPINDIV) atmeans predict(mu fixedonly) post

melogit Contact AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC DistrustTrust AULPTrust $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC DistrustTrust AULPTrust) atmeans predict(mu fixedonly) post

melogit Response AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC DistrustTrust AULPTrust $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC DistrustTrust AULPTrust) atmeans predict(mu fixedonly) post

melogit Contact AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC CollIndiv AULPINDIV DistrustTrust AULPTrust $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC CollIndiv AULPINDIV DistrustTrust AULPTrust) atmeans predict(mu fixedonly) post

melogit Response AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC CollIndiv AULPINDIV DistrustTrust AULPTrust $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC CollIndiv AULPINDIV DistrustTrust AULPTrust) atmeans predict(mu fixedonly) post


*********************************************************************************

*Following estimates are for analysis presented in the Online-Appendix

*Table A.3.1: Balancing test
*Following commands are for the difference in the means between the treatment and control group, along with overall means; means for the treatment and control groups; and standard deviations (presented in the table)
global RespCharac Male TMT
global MFICharac Mature Offices Sustainable Regulated Profitmargin PFB Outreach Scale TM Forpro
global CountryCharac EngOff Africa EAP EEC LAC MENA SA
	
	foreach x of varlist  $RespCharac $MFICharac $CountryCharac {
		su `x'
		gen Robs`x'=r(N)
		su `x' if AULP==1
		gen Robs`x't=r(N)
		gen Rmean`x'=r(mean)
		gen Rsd`x'=r(sd)
		su `x' if AULP==0
		gen R1obs`x'C=r(N)
		gen R1mean`x'=r(mean)
		gen R1sd`x'=r(sd)
		reg `x' AULP
		gen beta`x' =_b[AULP]
		}

	** DISPLAY RESULTS
	noi di as txt "PANEL A"
	noi di as txt "{col 22}" "Overall" as txt "{col 32}" "Treatment Group" as txt "{col 62}" "Control Group" as txt "{col 92}" "Treatment-Control"
	noi di as txt "{col 22}" "Obs" as txt "{col 32}" "Obs" as txt "{col 42}" "Mean" as txt "{col 52}" "SD" as txt "{col 62}" "Obs" as txt "{col 72}" "Mean" as txt "{col 82}" "Std.Dev" as txt "{col 92}" "Diff T-C" 
	noi di as txt ""
	noi di as txt "Respondent's characteristics:"
	foreach v of varlist $RespCharac  {
	   	noi di as txt "`v'" "{col 22}" as res %6.0f Robs`v' "{col 32}" as res %6.0f Robs`v't "{col 42}" as res %6.3f Rmean`v' "{col 52}" as res %6.3f Rsd`v' "{col 62}" as res %6.0f R1obs`v'C "{col 72}" as res %6.3f R1mean`v' "{col 82}" as res %6.3f R1sd`v' "{col 92}"  as res %6.3f  beta`v' 
		}
	noi di as txt ""
	noi di as txt "MFIs' characteristics:"
	foreach v of varlist $MFICharac  {
	   	noi di as txt "`v'" "{col 22}" as res %6.0f Robs`v' "{col 32}" as res %6.0f Robs`v't "{col 42}" as res %6.3f Rmean`v' "{col 52}" as res %6.3f Rsd`v' "{col 62}" as res %6.0f R1obs`v'C "{col 72}" as res %6.3f R1mean`v' "{col 82}" as res %6.3f R1sd`v' "{col 92}"  as res %6.3f  beta`v' 
		}
	noi di as txt ""
	noi di as txt "MFIs' Country characteristics:"
	foreach v of varlist $CountryCharac  {
	   	noi di as txt "`v'" "{col 22}" as res %6.0f Robs`v' "{col 32}" as res %6.0f Robs`v't "{col 42}" as res %6.3f Rmean`v' "{col 52}" as res %6.3f Rsd`v' "{col 62}" as res %6.0f R1obs`v'C "{col 72}" as res %6.3f R1mean`v' "{col 82}" as res %6.3f R1sd`v' "{col 92}"  as res %6.3f  beta`v' 
		}
		
*p-values for the last column in table A.3.1 can be attained from the following set of commands, for both chi2 and wilcoxon test
*Chi2
global varoutcomes1 "Male TMT Mature Sustainable Regulated Outreach Scale TM Forpro EngOff Africa EAP EEC LAC MENA SA"
putexcel set "chi2.xlsx", sheet("chi2_test") replace
putexcel A1=("Variable") B1=("Chi2") C1=("p (Chi)")
local row=2
foreach var of global varoutcomes1 {
    tabulate AULP `var', chi2 expected
	putexcel A`row' = ("`var'")
	putexcel B`row' = (r(chi2))
	putexcel C`row' = (r(p))
	local ++row
}

*Wicoxon ranksum
ranksum Offices, by(AULP)
ranksum Profitmargin, by(AULP)
ranksum PFB, by(AULP)
 
*Table C.1: Testing main hypotheses - Multi-level modeling 
melogit Contact AULP $Controls || CountryID:
margins, dydx(AULP) atmeans predict(mu fixedonly) post

melogit Response AULP $Controls || CountryID:
margins, dydx(AULP) atmeans predict(mu fixedonly) post

melogit Contact AULP OIC AULPOIC $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC) atmeans predict(mu fixedonly) post

melogit Response AULP OIC AULPOIC $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC) atmeans predict(mu fixedonly) post

melogit Contact AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC) atmeans predict(mu fixedonly) post

melogit Response AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC $Controls || CountryID:
margins, dydx(AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC) atmeans predict(mu fixedonly) post

*Table C.2 (a): Survey waves overview – Details on response statistics by survey wave
tab SurveyStat if Initialemail1==1 & Contact==1
tab SurveyStat if Firstreminder2==1 & Contact==1
tab SurveyStat if Secondreminder3==1 & Contact==1
tab SurveyStat if Thirdreminder4==1 & Contact==1
tab SurveyStat if Fourthreminder5==1 & Contact==1

*Table C.2 (b): Survey waves overview – Details on survey waves by response statistic
*PS: the total here is 606 complete responses that can be used in the analysis
tab SurveyStat if Initialemail1==1
tab SurveyStat if Firstreminder2==1
tab SurveyStat if Secondreminder3==1
tab SurveyStat if Thirdreminder4==1
tab SurveyStat if Fourthreminder5==1

*Table D.1 (a): Non-response analyses
*Creating interaction terms
gen AULPEngOff1 = AULP*EngOff
gen AULPLAC1 = AULP*LAC

*PS: For getting McFadden R2, use "fitstat" after logistic regression (i.e., before margins' command)
logit Nonresponse AULP EngOff AULPEngOff1,cluster(UniqueMFI) nolog
margins, dydx(AULP EngOff AULPEngOff1) atmeans post

logit Nonresponse AULP LAC AULPLAC1,cluster(UniqueMFI) nolog
margins, dydx(AULP LAC AULPLAC1) atmeans post

*D.1: Non-response
global varoutcomes2 "Male TMT Mature Offices Sustainable Regulated Profitmargin PFB Outreach Scale TM Forpro EngOff Africa EAP EEC LAC MENA SA"
foreach var of global varoutcomes2 {
  generate AULP`var' = AULP*`var'
}

*PS: For getting McFadden R2, use "fitstat" after logistic regression (i.e., before margins' command)
*Table D.1 (b): Non-response – Individual and regional characteristics
logit Nonresponse AULP Male AULPMale,cluster(UniqueMFI) nolog
margins, dydx(AULP Male AULPMale) atmeans post

logit Nonresponse AULP TMT AULPTMT,cluster(UniqueMFI) nolog
margins, dydx(AULP TMT AULPTMT) atmeans post

logit Nonresponse AULP EngOff AULPEngOff,cluster(UniqueMFI) nolog
margins, dydx(AULP EngOff AULPEngOff) atmeans post

logit Nonresponse AULP Africa AULPAfrica,cluster(UniqueMFI) nolog
margins, dydx(AULP Africa AULPAfrica) atmeans post

logit Nonresponse AULP EAP AULPEAP,cluster(UniqueMFI) nolog
margins, dydx(AULP EAP AULPEAP) atmeans post

logit Nonresponse AULP EEC AULPEEC,cluster(UniqueMFI) nolog
margins, dydx(AULP EEC AULPEEC) atmeans post

logit Nonresponse AULP LAC AULPLAC,cluster(UniqueMFI) nolog
margins, dydx(AULP LAC AULPLAC) atmeans post

logit Nonresponse AULP MENA AULPMENA,cluster(UniqueMFI) nolog
margins, dydx(AULP MENA AULPMENA) atmeans post

logit Nonresponse AULP SA AULPSA,cluster(UniqueMFI) nolog
margins, dydx(AULP SA AULPSA) atmeans post

*Table D.1 (c): Non-response – MFI characteristics
logit Nonresponse AULP Mature AULPMature,cluster(UniqueMFI) nolog
margins, dydx(AULP Mature AULPMature) atmeans post

logit Nonresponse AULP Offices AULPOffices,cluster(UniqueMFI) nolog
margins, dydx(AULP Offices AULPOffices) atmeans post

logit Nonresponse AULP Sustainable AULPSustainable,cluster(UniqueMFI) nolog
margins, dydx(AULP Sustainable AULPSustainable) atmeans post

logit Nonresponse AULP Regulated AULPRegulated,cluster(UniqueMFI) nolog
margins, dydx(AULP Regulated AULPRegulated) atmeans post

logit Nonresponse AULP Profitmargin AULPProfitmargin,cluster(UniqueMFI) nolog
margins, dydx(AULP Profitmargin AULPProfitmargin) atmeans post

logit Nonresponse AULP PFB AULPPFB,cluster(UniqueMFI) nolog
margins, dydx(AULP PFB AULPPFB) atmeans post

logit Nonresponse AULP Outreach AULPOutreach,cluster(UniqueMFI) nolog
margins, dydx(AULP Outreach AULPOutreach) atmeans post

logit Nonresponse AULP Scale AULPScale,cluster(UniqueMFI) nolog
margins, dydx(AULP Scale AULPScale) atmeans post

logit Nonresponse AULP TM AULPTM,cluster(UniqueMFI) nolog
margins, dydx(AULP TM AULPTM) atmeans post

logit Nonresponse AULP Forpro AULPForpro,cluster(UniqueMFI) nolog
margins, dydx(AULP Forpro AULPForpro) atmeans post

*Table D.2 (a): Data quality
*Changing time from seconds to minutes for those who completed the survey
gen timeinmins=Durationinseconds/60
replace timeinmins = . if Response==0

* 7a) Taking log of time
gen lntimemins = log(timeinmins)

reg lntimemins AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC TM Mature, cluster(UniqueMFI)

* 7b) Ratio for (Log of time / Total items in Questionnaire)
gen timetoitems = lntimemins/TotalQuestionnaireitems

reg timetoitems AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC TM Mature, cluster(UniqueMFI)

* 7c) Filled items ratio (missing items ratio; values 0 to 1)
reg Filleditemsratio AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC TM Mature, cluster(UniqueMFI)

* 7d) Recontact - Marginal effects for recontact variable
*PS: For getting McFadden R2, use "fitstat" after logistic regression (i.e., before margins' command)
logit Recontact AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC TM Mature, cluster(UniqueMFI) nolog
margins, dydx(AULP OIC Trans AULP OIC Trans AULPOIC AULPTrans TransOIC AULPTransOIC) atmeans post

*Number of observations with respect to each independent variable
gen Lntimepresent=1
replace Lntimepresent = . if missing(Lntime)

gen Fitempresent=1
replace Fitempresent= . if missing(Filleditemsratio)

gen recontactpresent=1
replace recontactpresent= . if missing(Recontact)

*No of observations for Lntime
sum AULP if AULP==1 & Lntimepresent==1
sum OIC if OIC==1 & Lntimepresent==1
sum AULPOIC if AULPOIC==1 & Lntimepresent==1
sum Trans if Trans==1 & Lntimepresent==1
sum AULPTrans if AULPTrans==1 & Lntimepresent==1
sum TransOIC if TransOIC==1 & Lntimepresent==1
sum AULPTransOIC if AULPTransOIC==1 & Lntimepresent==1

*No of observations for Filled items ratio
sum AULP if AULP==1 & Fitempresent==1
sum OIC if OIC==1 & Fitempresent==1
sum AULPOIC if AULPOIC==1 & Fitempresent==1
sum Trans if Trans==1 & Fitempresent==1
sum AULPTrans if AULPTrans==1 & Fitempresent==1
sum TransOIC if TransOIC==1 & Fitempresent==1
sum AULPTransOIC if AULPTransOIC==1 & Fitempresent==1

*No of observations for Recontact
sum AULP if AULP==1 & recontactpresent==1
sum OIC if OIC==1 & recontactpresent==1
sum AULPOIC if AULPOIC==1 & recontactpresent==1
sum Trans if Trans==1 & recontactpresent==1
sum AULPTrans if AULPTrans==1 & recontactpresent==1
sum TransOIC if TransOIC==1 & recontactpresent==1
sum AULPTransOIC if AULPTransOIC==1 & recontactpresent==1

*Table D.2 (b): Model 7 with winsorized time variables
*One tail winsorizing (at 2.5 percent) because the time variable is positively skewed
winsor lntimemins, gen (lntime_w) p(0.025) highonly
gen wtimetoitems = lntime_w/TotalQuestionnaireitems

* 7a) Winsorized log of time
reg lntime_w AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC, cluster(UniqueMFI)

* 7b) Ratio for (Winsorized Log of time / Total items in Questionnaire)
reg wtimetoitems AULP OIC AULPOIC Trans AULPTrans TransOIC AULPTransOIC, cluster(UniqueMFI)

*Figure D.4.1: Time spent completing the survey 
graph box timeinmins, nooutsides name(box1, replace) ytitle("Time in minutes")  ylabel(0(5)35) note("Source: Authors' survey") graphregion(color(white))

*Table D.4.1 is prepared by looking into the details of the received responses

*Table D.5: Variables used in data quality checks
sum Nonresponse AltNonresponse lntimemins timetoitems lntime_w wtimetoitems Filleditemsratio Recontact

*Table D.6: Spearman correlations
* Dummy variable for AULP, OIC & Trans is created for the cases for responded to the survey
gen AULPsp = 0
replace AULPsp = 1 if AULP==1
replace AULPsp = . if missing(Recontact)

gen OICsp = 0
replace OICsp = 1 if OIC==1
replace OICsp = . if missing(Recontact)

gen Transsp = 0
replace Transsp = 1 if Trans==1
replace Transsp = . if missing(Recontact)

spearman AULPsp OICsp Transsp lntimemins timetoitems Filleditemsratio Recontact, pw stats(rho obs p) star(0.01)



               ***End of the do-file***